# Contributing

Thank you for your interest in contributing to this project.

## Issues

Please be as descriptive as possible about issues encountered.

## Requests

Feel free to submit requests for other icons from Phantasy Star Online (the original).

## Collaboration

This project welcomes improvements and new icons. Open and unassigned issues listed on the issue tracker may be claimed. Other changes are welcome for consideration, the open issues simply reflect the maintainer's vision.

The repository is intended to be relatively easy to read and maintain, so please be ready to discuss and be open to feedback.

## What to do

- Format your SVG to keep one line for one idea (e.g. an element tag, an attribute, or a set of related attributes)
- Add comments describing the different fragments
- Follow the existing patterns

When making a pull request:

- Your code commits should be logical, atomic, and well described as much as possible
- Tag your PR title with any issues you are addressing in the title
- Your pull request should clearly explain its purpose
- Be open to a collaborative code review
- Works in progress are acceptable, but clearly denote remaining tasks

Why?

- The source code as a whole can be kept consistent and understandable
- You may learn something new; the maintainers may learn something new
- Maintainers and future contributors can more easily understand intentions when looking back

## What not to do

- Do not submit raster images (PNG, JPEG, etc.)
- Do not submit outputs of SVG editing programs directly (these tend to be noisy). The SVG should be readable as source code and relatively basic (follow the existing pattern)
- Do not submit works incompatible with the license of the project
- Do not submit works for which you are unauthorized to distribute

Why not?

- This repository is intended as an academic exercise of building SVGs by hand and understanding SVG elements.

## Attribution

An `AUTHORS.md` file will be maintained to list contributors to the project. By opening a pull request, you agree to release your works under the same license as the project.
