# Contributing

Thank you for your interest in contributing to this project.

## Issues

Please be as descriptive as possible about issues encountered.

## Feature requests

Feel free to submit ideas. Be aware that some items may be out of the intended scope for the vision of this particular project and will be closed or kept on the back burner.

## Code collaboration

This project welcomes improvements and new features. Open and unassigned issues listed on the issue tracker may be claimed. Other changes are welcome for consideration, the open issues simply reflect the maintainer's vision.

The repository is intended to be relatively easy to read and maintain while using clean design, so please be ready to discuss and be open to feedback.

## Pull requests

Generally:

- Use descriptive and spelled-out names for variables, methods, etc.
- Add documentation for all object types, globals, class members, etc.
- Add informative comments around non-trivial code
- The most elegant solutions are preferred, especially if it means less code, but this is negotiable
- Follow the existing patterns

When making a pull request:

- Your code commits should be logical, atomic, and well described as much as possible
- Tag your PR title with any issues you are addressing in the title
- Your pull request should clearly explain its purpose
- Test your code with a production build (see [README.md](README.md))
- Document what testing you did
- Follow the patterns of other pull requests
- Be open to a collaborative code review
- Works in progress are acceptable, but clearly denote remaining tasks

Why?

- The source code as a whole can be kept consistent and readable
- You may learn something new; the maintainers may learn something new
- Maintainers and future contributors can more easily understand intentions when looking back
- Bugs can be preemptively identified
- These are good habits for basic [software traceability](https://en.wikipedia.org/wiki/Traceability#Systems_and_software_development)

## Attribution

An `AUTHORS.md` file will be maintained to list contributors to the project. By opening a pull request, you agree to release your code under the same license as the project.
